﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// Base class of the settings panels for Excel and ODS export.
    /// </summary>
    public abstract partial class ExcelODSSettingsControl : FormatSettingsControl
    {
        private const string PropSpreadSheetFormat = "spreadsheetformat";
        private const string PropCellTruncate = "celltruncate";
        private const string PropCellDistribution = "celldistribution";
        private const string PropFirstGroupAsSheets = "firstgroupassheets";
        private const string PropGroupLevel = "grouplevel";

        private readonly string[] cellDistrItemValues = {
            null,
            "staticlayout",
            "oneline",
            "linebreak",
            "multicells",
            "mergecells",
            "singlecell"
        };
 
        /// <summary>
        /// Creates the control.
        /// </summary>
        public ExcelODSSettingsControl()
        {
            InitializeComponent();

            cmbCellDistr.SelectedIndex = 0;
            cmbGroupLevels.SelectedIndex = 0;
            cmbNavigation.SelectedIndex = 0;
        }

        /// <inheritdoc />
        public override void CollectExportParameters(Dictionary<string, string> exportParams)
        {
            string cellDistr = cellDistrItemValues[cmbCellDistr.SelectedIndex];
            if (cellDistr != null)
            {
                exportParams[PropCellTruncate] = cellDistr;
            }
            
            switch(cmbCellDistr.SelectedIndex) {
                case 1:
                    exportParams[PropCellTruncate] = URLRenderData.ValueTrue;
                    break;
                case 2:
                    exportParams[PropCellTruncate] = URLRenderData.ValueFalse;
                    break;
            }
            if (chbNewSheetPerGroup.Checked)
            {
                exportParams[PropFirstGroupAsSheets] = URLRenderData.ValueTrue;
            }
            if (cmbGroupLevels.SelectedIndex > 0)
            {
                exportParams[PropGroupLevel] = cmbGroupLevels.SelectedIndex.ToString();
            }
        }

        /// <inheritdoc />
        public override bool HasGroups
        {
            set
            {
                chbNewSheetPerGroup.Enabled = value;
                cmbGroupLevels.Enabled = value;
            }
        }
    }
}
